#include "def.h"
#include "val.h"
#include "dfu.h"
#include "usb.h"
#include "mcu.h"


//-----MCU.C-----//
extern BYTE Wdt;                                 // Watch Dog Timer Default Value
extern void Initial_Mcu( void );

//-----DFU.C-----//
extern void Initial_DFU( void );

//-----SPK.C-----//
extern void Initial_SPK( void );

//-----USB.C-----//
extern EP0INFO Ep0;
extern void Initial_USB( void );


void main( void )
  { Initial_Mcu();                               // Initial 8051 SFR 
    Initial_DFU();
    Initial_SPK();
    Initial_USB();                               // USB.C
    while(1)
      { WDTCR = Wdt;
      }
  }
